"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const getCustomTypeFromNativeHailoType = (type) => {
    let result = constants_1.BASIC_NODE_TYPES.DEFAULT;
    if ([
        constants_1.HAILO_LAYER_TYPES.RESIZE,
        constants_1.HAILO_LAYER_TYPES.FORMAT_CONVERSION,
        constants_1.HAILO_LAYER_TYPES.NORMALIZATION,
        constants_1.HAILO_LAYER_TYPES.BATCH_NORM,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.FORMAT_CHANGE;
    }
    else if ([
        constants_1.HAILO_LAYER_TYPES.CONV,
        constants_1.HAILO_LAYER_TYPES.DW,
        constants_1.HAILO_LAYER_TYPES.DECONV,
        constants_1.HAILO_LAYER_TYPES.DENSE,
        constants_1.HAILO_LAYER_TYPES.ELEMENTWICE_ADD,
        constants_1.HAILO_LAYER_TYPES.ELEMENTWICE_SUB,
        constants_1.HAILO_LAYER_TYPES.ELEMENTWICE_MULT,
        constants_1.HAILO_LAYER_TYPES.ELEMENTWICE_MUL,
        constants_1.HAILO_LAYER_TYPES.MATMUL,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.COMPUTE_INTENSE;
    }
    else if ([
        constants_1.HAILO_LAYER_TYPES.AVGPOOL,
        constants_1.HAILO_LAYER_TYPES.MAXPOOL,
        constants_1.HAILO_LAYER_TYPES.REDUCE_SUM,
        constants_1.HAILO_LAYER_TYPES.REDUCE_MAX,
        constants_1.HAILO_LAYER_TYPES.ARGMAX,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.DIMENSION_CHANGE;
    }
    else if ([constants_1.HAILO_LAYER_TYPES.SOFTMAX, constants_1.HAILO_LAYER_TYPES.OTHERS].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.ACTIVATION;
    }
    else if ([
        constants_1.HAILO_LAYER_TYPES.CONCAT,
        constants_1.HAILO_LAYER_TYPES.FEATURE_SPLITTER,
        constants_1.HAILO_LAYER_TYPES.FEATURE_SHUFFLE,
        constants_1.HAILO_LAYER_TYPES.SLICE,
        constants_1.HAILO_LAYER_TYPES.DEPTH_TO_SPACE,
        constants_1.HAILO_LAYER_TYPES.SPACE_TO_DEPTH,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.REORDERING;
    }
    else if ([constants_1.HAILO_LAYER_TYPES.INPUT, constants_1.HAILO_LAYER_TYPES.INPUT_LAYER, constants_1.HAILO_LAYER_TYPES.CONST_INPUT].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.INPUT;
    }
    else if ([constants_1.HAILO_LAYER_TYPES.OUTPUT, constants_1.HAILO_LAYER_TYPES.OUTPUT_LAYER].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.OUTPUT;
    }
    else if ([constants_1.HAILO_LAYER_TYPES.CONTEXT].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.CONTEXT;
    }
    else if ([constants_1.HAILO_LAYER_TYPES.CONTEXT_INPUT].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.CONTEXT_INPUT;
    }
    else if ([constants_1.HAILO_LAYER_TYPES.CONTEXT_OUTPUT].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.CONTEXT_OUTPUT;
    }
    return result;
};
exports.default = getCustomTypeFromNativeHailoType;
