"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const getCustomTypeFromOnnxType = (type) => {
    let result = constants_1.BASIC_NODE_TYPES.DEFAULT;
    if ([constants_1.ONNX_LAYER_TYPES.RESIZE, constants_1.ONNX_LAYER_TYPES.UPSAMPLE].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.FORMAT_CHANGE;
    }
    else if ([
        constants_1.ONNX_LAYER_TYPES.NORMALIZATION,
        constants_1.ONNX_LAYER_TYPES.BATCH_NORMALIZATION,
        constants_1.ONNX_LAYER_TYPES.INSTANCE_NORMALIZATION,
        constants_1.ONNX_LAYER_TYPES.LAYER_NORMALIZATION,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.DEFAULT;
    }
    else if ([
        constants_1.ONNX_LAYER_TYPES.CONV_2D,
        constants_1.ONNX_LAYER_TYPES.TRANSPOSE_CONV,
        constants_1.ONNX_LAYER_TYPES.GEMM,
        constants_1.ONNX_LAYER_TYPES.MATMUL,
        constants_1.ONNX_LAYER_TYPES.ADD,
        constants_1.ONNX_LAYER_TYPES.SUB,
        constants_1.ONNX_LAYER_TYPES.NEG,
        constants_1.ONNX_LAYER_TYPES.DIV,
        constants_1.ONNX_LAYER_TYPES.MUL,
        constants_1.ONNX_LAYER_TYPES.MIN,
        constants_1.ONNX_LAYER_TYPES.MAX,
        constants_1.ONNX_LAYER_TYPES.LSTM,
        constants_1.ONNX_LAYER_TYPES.RNN,
        constants_1.ONNX_LAYER_TYPES.ONE_HOT,
        constants_1.ONNX_LAYER_TYPES.NMS,
        constants_1.ONNX_LAYER_TYPES.EINSUM,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.COMPUTE_INTENSE;
    }
    else if ([
        constants_1.ONNX_LAYER_TYPES.AVERAGE_POOL_2D,
        constants_1.ONNX_LAYER_TYPES.GLOBAL_AVERAGE_POOL_2D,
        constants_1.ONNX_LAYER_TYPES.MAX_POOL_2D,
        constants_1.ONNX_LAYER_TYPES.GLOBAL_MAX_POOL_2D,
        constants_1.ONNX_LAYER_TYPES.SUM,
        constants_1.ONNX_LAYER_TYPES.REDUCE_SUM,
        constants_1.ONNX_LAYER_TYPES.REDUCE_SUM_SQUARE,
        constants_1.ONNX_LAYER_TYPES.REDUCE_L2,
        constants_1.ONNX_LAYER_TYPES.MEAN,
        constants_1.ONNX_LAYER_TYPES.REDUCE_MEAN,
        constants_1.ONNX_LAYER_TYPES.REDUCE_MAX,
        constants_1.ONNX_LAYER_TYPES.ARG_MAX,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.DIMENSION_CHANGE;
    }
    else if ([
        constants_1.ONNX_LAYER_TYPES.SOFTMAX,
        constants_1.ONNX_LAYER_TYPES.LOG_SOFTMAX,
        constants_1.ONNX_LAYER_TYPES.RELU,
        constants_1.ONNX_LAYER_TYPES.RELU6,
        constants_1.ONNX_LAYER_TYPES.TANH,
        constants_1.ONNX_LAYER_TYPES.EXP,
        constants_1.ONNX_LAYER_TYPES.PRELU,
        constants_1.ONNX_LAYER_TYPES.LESS,
        constants_1.ONNX_LAYER_TYPES.SQRT,
        constants_1.ONNX_LAYER_TYPES.LEAKY_RELU,
        constants_1.ONNX_LAYER_TYPES.ABS,
        constants_1.ONNX_LAYER_TYPES.ELU,
        constants_1.ONNX_LAYER_TYPES.HARD_SWISH,
        constants_1.ONNX_LAYER_TYPES.LOG,
        constants_1.ONNX_LAYER_TYPES.GREATER,
        constants_1.ONNX_LAYER_TYPES.SIGMOID,
        constants_1.ONNX_LAYER_TYPES.CLIP,
        constants_1.ONNX_LAYER_TYPES.SIGN,
        constants_1.ONNX_LAYER_TYPES.SOFT_PLUS,
        constants_1.ONNX_LAYER_TYPES.ERF,
        constants_1.ONNX_LAYER_TYPES.HARD_SIGMOID,
        constants_1.ONNX_LAYER_TYPES.SOFT_SIGN,
        constants_1.ONNX_LAYER_TYPES.RECIPROCAL,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.ACTIVATION;
    }
    else if ([
        constants_1.ONNX_LAYER_TYPES.CONCAT,
        constants_1.ONNX_LAYER_TYPES.SPLIT,
        constants_1.ONNX_LAYER_TYPES.SLICE,
        constants_1.ONNX_LAYER_TYPES.DEPTH_TO_SPACE,
        constants_1.ONNX_LAYER_TYPES.SPACE_TO_DEPTH,
        constants_1.ONNX_LAYER_TYPES.RESHAPE,
        constants_1.ONNX_LAYER_TYPES.TRANSPOSE,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.REORDERING;
    }
    else if ([constants_1.ONNX_LAYER_TYPES.INPUT].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.INPUT;
    }
    return result;
};
exports.default = getCustomTypeFromOnnxType;
