"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getFileExtensionFromPath_1 = __importDefault(require("../utils/getFileExtensionFromPath"));
const getFilePathRecursively_1 = __importDefault(require("./getFilePathRecursively"));
const getFilePathByExtension = (dir, extension) => {
    const allPaths = (0, getFilePathRecursively_1.default)(dir);
    return allPaths.find(path => {
        const pathExtension = (0, getFileExtensionFromPath_1.default)(path);
        return pathExtension === extension;
    });
};
exports.default = getFilePathByExtension;
