"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const getFilePathRecursively = (dir) => {
    let results = [];
    const list = fs_1.default.readdirSync(dir);
    let pending = list.length;
    if (!pending)
        return results;
    for (let file of list) {
        file = path_1.default.resolve(dir, file);
        const stat = fs_1.default.statSync(file);
        if (stat && stat.isDirectory()) {
            results = results.concat(getFilePathRecursively(file));
        }
        else {
            results.push(file);
        }
        if (!--pending)
            return results;
    }
    return results;
};
exports.default = getFilePathRecursively;
