"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getCustomTypeFromBackendTFLiteType_1 = __importDefault(require("../helpers/getCustomTypeFromBackendTFLiteType"));
const getMatchedNodesFromBlocks_1 = __importDefault(require("../helpers/getMatchedNodesFromBlocks"));
const PARSING_STATUSES = {
    PARSED: 'parsed',
    FAILED: 'failed',
    UNSUPPORTED: 'out_of_scope',
};
const curryMapBackendLayerToOriginalNode = (startNodes = [], endNodes = [], blocks = {}) => ([name, data]) => {
    var _a, _b, _c, _d, _e, _f, _g;
    const matchedNodes = (0, getMatchedNodesFromBlocks_1.default)(name, blocks);
    return {
        id: name || '',
        type: ((_a = data === null || data === void 0 ? void 0 : data.output) === null || _a === void 0 ? void 0 : _a.length)
            ? (0, getCustomTypeFromBackendTFLiteType_1.default)(data === null || data === void 0 ? void 0 : data.type)
            : 'output',
        data: {
            label: name,
            shape: (_b = data === null || data === void 0 ? void 0 : data.input_shapes[0]) === null || _b === void 0 ? void 0 : _b.join('x'),
            size: '8bit',
            targetAvailable: !!((_c = data === null || data === void 0 ? void 0 : data.input) === null || _c === void 0 ? void 0 : _c.length),
            sourceAvailable: !!((_d = data === null || data === void 0 ? void 0 : data.output) === null || _d === void 0 ? void 0 : _d.length),
            unsupported: ((_e = data.params) === null || _e === void 0 ? void 0 : _e.parsing_status) === PARSING_STATUSES.UNSUPPORTED,
            supported: ((_f = data.params) === null || _f === void 0 ? void 0 : _f.parsing_status) === PARSING_STATUSES.PARSED && data.type !== 'input' && data.type !== 'output',
            failed: ((_g = data.params) === null || _g === void 0 ? void 0 : _g.parsing_status) === PARSING_STATUSES.FAILED,
            start: startNodes.includes(name),
            end: endNodes.includes(name),
            newStart: false,
            newEnd: false,
            matchedNodes,
        },
        draggable: true,
        selectable: true,
        position: { x: 0, y: 0 },
    };
};
exports.default = curryMapBackendLayerToOriginalNode;
