"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const getInputShapes_1 = __importDefault(require("../helpers/getInputShapes"));
const curryMapFrontendInputToOriginalNode = (outputs) => (layer) => {
    var _a;
    // @ts-ignore
    const name = ((_a = layer === null || layer === void 0 ? void 0 : layer._name) === null || _a === void 0 ? void 0 : _a.split('\n')[0].replaceAll(';', '_')) || '';
    const shape = (0, getInputShapes_1.default)(layer, outputs).join(' ,');
    return {
        id: name,
        type: constants_1.BASIC_NODE_TYPES.INPUT,
        data: {
            label: name,
            shape,
            size: '8bit',
            targetAvailable: false,
            sourceAvailable: true,
            unsupported: true,
            supported: false,
            failed: false,
            start: false,
            end: false,
            newStart: false,
            newEnd: false,
        },
        draggable: true,
        selectable: true,
        position: { x: 0, y: 0 },
    };
};
exports.default = curryMapFrontendInputToOriginalNode;
