"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getCustomTypeFromOnnxType_1 = __importDefault(require("../helpers/getCustomTypeFromOnnxType"));
const getCustomTypeFromFrontendTFLiteType_1 = __importDefault(require("../helpers/getCustomTypeFromFrontendTFLiteType"));
const getNameFromLayerByOutput_1 = __importDefault(require("../helpers/getNameFromLayerByOutput"));
const getInputNodeNames_1 = __importDefault(require("../helpers/getInputNodeNames"));
const getOutputNodeNames_1 = __importDefault(require("../helpers/getOutputNodeNames"));
const getInputNodeShapes_1 = __importDefault(require("../helpers/getInputNodeShapes"));
const getOutputNodeShapes_1 = __importDefault(require("../helpers/getOutputNodeShapes"));
const constants_1 = require("../constants");
const curryMapFrontendNodeToOriginalNode = (modelExtension, inputs, outputs) => (layer) => {
    var _a, _b, _c, _d;
    const targetAvailable = !!((_a = (0, getInputNodeNames_1.default)(layer, inputs)) === null || _a === void 0 ? void 0 : _a.length);
    const sourceAvailable = !!((_b = (0, getOutputNodeNames_1.default)(layer, outputs)) === null || _b === void 0 ? void 0 : _b.length);
    let shapes = [];
    if (!targetAvailable) {
        shapes = (0, getInputNodeShapes_1.default)(layer, outputs);
    }
    else {
        shapes = (0, getOutputNodeShapes_1.default)(layer, inputs);
    }
    let type;
    if (!targetAvailable) {
        type = constants_1.BASIC_NODE_TYPES.INPUT;
    }
    else if (!sourceAvailable) {
        type = constants_1.BASIC_NODE_TYPES.OUTPUT;
    }
    else if (modelExtension === constants_1.MODEL_FILE_EXTENSIONS.ONNX) {
        type = (0, getCustomTypeFromOnnxType_1.default)((_c = layer === null || layer === void 0 ? void 0 : layer._type) === null || _c === void 0 ? void 0 : _c.name);
    }
    else {
        type = (0, getCustomTypeFromFrontendTFLiteType_1.default)((_d = layer === null || layer === void 0 ? void 0 : layer._type) === null || _d === void 0 ? void 0 : _d.name);
    }
    const formattedShapes = shapes.join(' ,');
    const name = (0, getNameFromLayerByOutput_1.default)(layer);
    return {
        id: name || '',
        type,
        data: {
            label: name,
            shape: formattedShapes,
            size: '8bit',
            targetAvailable,
            sourceAvailable,
            unsupported: !targetAvailable || !sourceAvailable,
            supported: targetAvailable && sourceAvailable,
            failed: false,
            start: false,
            end: false,
            newStart: false,
            newEnd: false,
        },
        draggable: true,
        selectable: true,
        position: { x: 0, y: 0 },
    };
};
exports.default = curryMapFrontendNodeToOriginalNode;
