"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getOutputShapes_1 = __importDefault(require("../helpers/getOutputShapes"));
const constants_1 = require("../constants");
const curryMapFrontendOutputToOriginalNode = (inputs) => (layer) => {
    var _a;
    // @ts-ignore
    const name = ((_a = layer === null || layer === void 0 ? void 0 : layer._name) === null || _a === void 0 ? void 0 : _a.split('\n')[0].replaceAll(';', '_')) || '';
    const shape = (0, getOutputShapes_1.default)(layer, inputs).join(' ,');
    return {
        id: name,
        type: constants_1.BASIC_NODE_TYPES.OUTPUT,
        data: {
            label: name,
            shape,
            size: '8bit',
            targetAvailable: true,
            sourceAvailable: false,
            unsupported: true,
            supported: false,
            failed: false,
            start: false,
            end: false,
            newStart: false,
            newEnd: false,
        },
        draggable: true,
        selectable: true,
        position: { x: 0, y: 0 },
    };
};
exports.default = curryMapFrontendOutputToOriginalNode;
