"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getCustomTypeFromNativeHailoType_1 = __importDefault(require("../helpers/getCustomTypeFromNativeHailoType"));
const toShapeFormat_1 = __importDefault(require("../formatters/toShapeFormat"));
const mapHarLayerToHailoNode = ([name, layerData]) => {
    var _a, _b, _c, _d, _e, _f;
    return {
        id: name || '',
        type: (0, getCustomTypeFromNativeHailoType_1.default)(layerData.type),
        data: {
            label: name,
            shape: (_a = layerData === null || layerData === void 0 ? void 0 : layerData.input_shapes) === null || _a === void 0 ? void 0 : _a.map(shape => {
                return shape.join('x');
            }).join(', '),
            size: '8bit',
            targetAvailable: !!((_b = layerData === null || layerData === void 0 ? void 0 : layerData.input) === null || _b === void 0 ? void 0 : _b.length),
            sourceAvailable: !!((_c = layerData === null || layerData === void 0 ? void 0 : layerData.output) === null || _c === void 0 ? void 0 : _c.length),
            activation: ((_d = layerData === null || layerData === void 0 ? void 0 : layerData.params) === null || _d === void 0 ? void 0 : _d.activation) || '',
            kernel: ((_e = layerData === null || layerData === void 0 ? void 0 : layerData.params) === null || _e === void 0 ? void 0 : _e.kernel_shape) ? (0, toShapeFormat_1.default)(layerData.params.kernel_shape) : '',
            batchNorm: ((_f = layerData === null || layerData === void 0 ? void 0 : layerData.params) === null || _f === void 0 ? void 0 : _f.batch_norm) || '',
            originalNames: (layerData === null || layerData === void 0 ? void 0 : layerData.original_names) ? layerData === null || layerData === void 0 ? void 0 : layerData.original_names : [],
            newStart: false,
            newEnd: false,
        },
        draggable: true,
        selectable: true,
        position: { x: 0, y: 0 },
    };
};
exports.default = mapHarLayerToHailoNode;
