"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const multer_1 = __importDefault(require("multer"));
const fs_1 = __importDefault(require("fs"));
const getTempDirLocation_1 = __importDefault(require("../utils/getTempDirLocation"));
exports.default = multer_1.default.diskStorage({
    destination: function (req, file, cb) {
        if (!file)
            return;
        const { id } = req.params;
        const tempDirLocation = (0, getTempDirLocation_1.default)();
        const dir = `${tempDirLocation}/${id}`;
        if (!fs_1.default.existsSync(dir)) {
            fs_1.default.mkdirSync(dir, { recursive: true });
        }
        cb(null, dir);
    },
    filename: function (req, file, cb) {
        cb(null, file.originalname);
    },
});
