"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const json = __importStar(require("../utils/json"));
const zip = __importStar(require("../utils/zip"));
const python = __importStar(require("../utils/python"));
const hdf5 = __importStar(require("../utils/hdf5"));
const tar = __importStar(require("../utils/tar"));
const protobuf = __importStar(require("../utils/protobuf"));
const flatbuffers = __importStar(require("../utils/flatbuffers"));
const xml = __importStar(require("../utils/xml"));
const Metadata_1 = __importDefault(require("./Metadata"));
const ModelContext = class {
    constructor(context, identifier, stream) {
        this._context = context;
        this._tags = new Map();
        this._content = new Map();
        this._identifier = typeof identifier === 'string' ? identifier : context.identifier;
        this._stream = stream || context.stream;
    }
    get identifier() {
        return this._identifier;
    }
    get stream() {
        return this._stream;
    }
    request(file) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const result = yield this._context.request(file, 'utf-8', null);
                return result;
            }
            catch (error) {
                console.log(error);
            }
        });
    }
    fetch(file) {
        return __awaiter(this, void 0, void 0, function* () {
            const stream = yield this._context.request(file, null);
            return new ModelContext(this, file, stream, new Map());
        });
    }
    require(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return require(`../${id}`);
        });
    }
    exception(error) {
        if (error && this.identifier) {
            error.context = this.identifier;
        }
    }
    peek(type) {
        if (!this._content.has(type)) {
            this._content.set(type, undefined);
            const stream = this.stream;
            if (stream) {
                const position = stream.position;
                const match = (buffer, signature) => {
                    return (signature.length <= buffer.length &&
                        buffer.every((value, index) => signature[index] === undefined || signature[index] === value));
                };
                const buffer = stream.peek(Math.min(stream.length, 16));
                const skip = match(buffer, [0x80, undefined, 0x8a, 0x0a, 0x6c, 0xfc, 0x9c, 0x46, 0xf9, 0x20, 0x6a, 0xa8, 0x50, 0x19]) || // PyTorch
                    (type !== 'npz' && type !== 'zip' && match(buffer, [0x50, 0x4b, 0x03, 0x04])) || // Zip
                    (type !== 'hdf5' && match(buffer, [0x89, 0x48, 0x44, 0x46, 0x0d, 0x0a, 0x1a, 0x0a])) || // \x89HDF\r\n\x1A\n
                    Array.from(this._tags).some(([key, value]) => key !== 'flatbuffers' && value.size > 0) ||
                    Array.from(this._content.values()).some(obj => obj !== undefined);
                if (!skip) {
                    switch (type) {
                        case 'json': {
                            try {
                                const buffer = stream.peek(Math.min(this.stream.length, 0x1000));
                                if (stream.length < 0x7ffff000 &&
                                    (buffer.length < 8 || String.fromCharCode.apply(null, buffer.slice(0, 8)) !== '\x89HDF\r\n\x1A\n') &&
                                    buffer.some(v => v === 0x22 || v === 0x5b || v === 0x5d || v === 0x7b || v === 0x7d)) {
                                    const reader = json.TextReader.open(stream);
                                    if (reader) {
                                        const obj = reader.read();
                                        this._content.set(type, obj);
                                    }
                                }
                            }
                            catch (error) {
                                // continue regardless of error
                            }
                            break;
                        }
                        case 'json.gz': {
                            try {
                                const entries = this.peek('gzip');
                                if (entries && entries.size === 1) {
                                    const stream = entries.values().next().value;
                                    const reader = json.TextReader.open(stream);
                                    if (reader) {
                                        const obj = reader.read();
                                        this._content.set(type, obj);
                                    }
                                }
                            }
                            catch (error) {
                                // continue regardless of error
                            }
                            break;
                        }
                        case 'pkl': {
                            let unpickler = null;
                            const types = new Set();
                            try {
                                const archive = zip.Archive.open(stream, 'zlib');
                                const data = archive ? archive.entries.get('') : stream;
                                let condition = false;
                                if (data.length > 2) {
                                    const head = data.peek(2);
                                    condition = head[0] === 0x80 && head[1] < 7;
                                    if (!condition) {
                                        data.seek(-1);
                                        const tail = data.peek(1);
                                        data.seek(0);
                                        condition = tail[0] === 0x2e;
                                    }
                                }
                                if (condition) {
                                    const execution = new python.Execution();
                                    execution.on('resolve', (_, name) => types.add(name));
                                    const pickle = execution.__import__('pickle');
                                    unpickler = new pickle.Unpickler(data);
                                }
                            }
                            catch (error) {
                                // continue regardless of error
                            }
                            if (unpickler) {
                                const storages = new Map();
                                unpickler.persistent_load = saved_id => {
                                    if (Array.isArray(saved_id) && saved_id.length > 3) {
                                        switch (saved_id[0]) {
                                            case 'storage': {
                                                const [, storage_type, key, , size] = saved_id;
                                                if (!storages.has(key)) {
                                                    const storage = new storage_type(size);
                                                    storages.set(key, storage);
                                                }
                                                return storages.get(key);
                                            }
                                            default: {
                                                throw new python.Error(`Unsupported persistent load type '${saved_id[0]}'.`);
                                            }
                                        }
                                    }
                                };
                                try {
                                    const obj = unpickler.load();
                                    this._content.set(type, obj);
                                }
                                catch (error) {
                                    this._content.set(type, error);
                                }
                                if (!Array.from(types).every(name => !name.startsWith('__torch__.'))) {
                                    this._content.set(type, new Error("PyTorch standalone 'data.pkl' format not supported."));
                                }
                            }
                            break;
                        }
                        case 'hdf5': {
                            const file = hdf5.File.open(stream);
                            if (file) {
                                try {
                                    this._content.set(type, file.read());
                                }
                                catch (error) {
                                    this._content.set(type, error);
                                }
                            }
                            break;
                        }
                        case 'zip':
                        case 'tar':
                        case 'gzip': {
                            this._content.set('zip', undefined);
                            this._content.set('tar', undefined);
                            this._content.set('gzip', undefined);
                            let stream = this._stream;
                            try {
                                const archive = zip.Archive.open(this._stream, 'gzip');
                                if (archive) {
                                    let entries = archive.entries;
                                    if (entries.size === 1) {
                                        const key = entries.keys().next().value;
                                        stream = entries.values().next().value;
                                        const name = key === '' ? this.identifier.replace(/\.gz$/, '') : key;
                                        entries = new Map([[name, stream]]);
                                    }
                                    this._content.set('gzip', entries);
                                }
                            }
                            catch (error) {
                                this._content.set('gzip', error);
                            }
                            let skipTar = false;
                            try {
                                const archive = zip.Archive.open(stream, 'zip');
                                if (archive) {
                                    this._content.set('zip', archive.entries);
                                    skipTar = true;
                                }
                            }
                            catch (error) {
                                this._content.set('zip', error);
                            }
                            if (!skipTar) {
                                try {
                                    const archive = tar.Archive.open(stream);
                                    if (archive) {
                                        this._content.set('tar', archive.entries);
                                    }
                                }
                                catch (error) {
                                    this._content.set('tar', error);
                                }
                            }
                            break;
                        }
                        case 'npz': {
                            try {
                                const content = new Map();
                                const entries = this.peek('zip');
                                if (entries instanceof Map &&
                                    entries.size > 0 &&
                                    Array.from(entries.keys()).every(name => name.endsWith('.npy'))) {
                                    const execution = new python.Execution();
                                    for (const [name, stream] of entries) {
                                        const buffer = stream.peek();
                                        const bytes = execution.invoke('io.BytesIO', [buffer]);
                                        const array = execution.invoke('numpy.load', [bytes]);
                                        content.set(name, array);
                                    }
                                    this._content.set(type, content);
                                }
                            }
                            catch (error) {
                                // continue regardless of error
                            }
                            break;
                        }
                        default:
                    }
                }
                if (stream.position !== position) {
                    stream.seek(0);
                }
            }
        }
        return this._content.get(type);
    }
    read(type) {
        if (!this._content.has(type)) {
            switch (type) {
                case 'json': {
                    const reader = json.TextReader.open(this._stream);
                    if (reader) {
                        const obj = reader.read();
                        this._content.set('json', obj);
                        return obj;
                    }
                    break;
                }
                default:
            }
        }
        return this.peek(type);
    }
    tags(type) {
        if (!this._tags.has(type)) {
            let tags = new Map();
            const stream = this.stream;
            if (stream) {
                const position = stream.position;
                const signatures = [
                    [0x89, 0x48, 0x44, 0x46, 0x0d, 0x0a, 0x1a, 0x0a], // HDF5
                    [0x80, undefined, 0x8a, 0x0a, 0x6c, 0xfc, 0x9c, 0x46, 0xf9, 0x20, 0x6a, 0xa8, 0x50, 0x19], // PyTorch
                    [0x50, 0x4b], // Zip
                    [0x1f, 0x8b], // Gzip
                ];
                const skip = signatures.some(signature => signature.length <= stream.length &&
                    stream
                        .peek(signature.length)
                        .every((value, index) => signature[index] === undefined || signature[index] === value)) ||
                    (Array.from(this._tags).some(([key, value]) => key !== 'flatbuffers' && value.size > 0) && type !== 'pb+') ||
                    Array.from(this._content.values()).some(obj => obj !== undefined) ||
                    (stream.length < 0x7ffff000 && json.TextReader.open(stream));
                if (!skip && stream.length < 0x7ffff000) {
                    try {
                        switch (type) {
                            case 'pbtxt': {
                                const reader = protobuf.TextReader.open(stream);
                                tags = reader ? reader.signature() : tags;
                                break;
                            }
                            case 'pb': {
                                const reader = protobuf.BinaryReader.open(stream);
                                tags = reader.signature();
                                break;
                            }
                            case 'pb+': {
                                const reader = protobuf.BinaryReader.open(stream);
                                tags = reader.decode();
                                break;
                            }
                            case 'flatbuffers': {
                                if (stream.length >= 8) {
                                    const buffer = stream.peek(Math.min(32, stream.length));
                                    const reader = flatbuffers.BinaryReader.open(buffer);
                                    const identifier = reader.identifier;
                                    if (identifier.length > 0) {
                                        tags.set('file_identifier', identifier);
                                    }
                                }
                                break;
                            }
                            case 'xml': {
                                const reader = xml.TextReader.open(stream);
                                if (reader) {
                                    const document = reader.peek();
                                    const element = document.documentElement;
                                    const namespaceURI = element.namespaceURI;
                                    const localName = element.localName;
                                    const name = namespaceURI ? `${namespaceURI}:${localName}` : localName;
                                    tags.set(name, element);
                                }
                                break;
                            }
                            default:
                        }
                    }
                    catch (error) {
                        tags.clear();
                    }
                }
                if (stream.position !== position) {
                    stream.seek(position);
                }
            }
            this._tags.set(type, tags);
        }
        return this._tags.get(type);
    }
    metadata(name) {
        return Metadata_1.default.open(this, name);
    }
};
exports.default = ModelContext;
