"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const request_1 = __importDefault(require("../utils/request"));
const RootContext = class {
    constructor(folder, identifier, stream, entries) {
        this._folder = folder;
        this._identifier = identifier;
        this._stream = stream;
        this._entries = entries || new Map();
    }
    get identifier() {
        return this._identifier;
    }
    get stream() {
        return this._stream;
    }
    get entries() {
        return this._entries;
    }
    request(file, encoding, base) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield (0, request_1.default)(file, encoding, base === undefined ? this._folder : base);
            return result;
        });
    }
    require(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield require(`${id}.js`);
        });
    }
};
exports.default = RootContext;
