"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const request_1 = __importDefault(require("./utils/request"));
let entries;
exports.default = {
    setEntries: newEtries => {
        entries = newEtries;
    },
    request: (file, encoding, base) => {
        if (base === undefined) {
            const stream = entries.get(file);
            if (encoding) {
                const decoder = new TextDecoder(encoding);
                const buffer = stream.peek();
                const value = decoder.decode(buffer);
                return value;
            }
            return stream;
        }
        return (0, request_1.default)(file, encoding, base);
    },
};
