"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const extensions = new Set(['.zip', '.tar', '.tar.gz', '.tgz', '.gz']);
const factories = [];
exports.default = {
    registerFactory: (id, newFactories, containers) => {
        for (const extension of newFactories) {
            factories.push({ extension: extension, id: id });
            extensions.add(extension);
        }
        for (const extension of containers || []) {
            extensions.add(extension);
        }
    },
    getFactories: () => factories,
    getExtensions: () => extensions,
};
