"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const entries_1 = __importDefault(require("../entries"));
const getModules_1 = __importDefault(require("./getModules"));
const ModelContext_1 = __importDefault(require("../entities/ModelContext"));
const getEntryContext = (entries) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const rootFolder = files => {
            const map = files.map(file => file.split('/').slice(0, -1));
            const at = index => list => list[index];
            const rotate = list => (list.length === 0 ? [] : list[0].map((item, index) => list.map(at(index))));
            const equals = list => list.every(item => item === list[0]);
            const folder = rotate(map).filter(equals).map(at(0)).join('/');
            return folder.length === 0 ? folder : `${folder}/`;
        };
        const list = Array.from(entries).map(([name, stream]) => {
            return { name, stream };
        });
        const files = list.filter(entry => {
            if (entry.name.endsWith('/')) {
                return false;
            }
            if (entry.name.split('/').pop().startsWith('.')) {
                return false;
            }
            if (!entry.name.startsWith('./') && entry.name.startsWith('.')) {
                return false;
            }
            return true;
        });
        const folder = rootFolder(files.map(entry => entry.name));
        const filter = (queue, entries) => __awaiter(void 0, void 0, void 0, function* () {
            entries = new Map(Array.from(entries)
                .filter(([path]) => path.startsWith(folder))
                .map(([path, stream]) => [path.substring(folder.length), stream]));
            const entriesService = entries_1.default;
            entriesService.setEntries(entries);
            let matches = [];
            for (const entry of queue) {
                try {
                    const identifier = entry.name.substring(folder.length);
                    const context = new ModelContext_1.default(entriesService, identifier, entry.stream);
                    const modules = (0, getModules_1.default)(context);
                    for (const id of modules) {
                        /* eslint-disable no-await-in-loop */
                        const module = yield require(`../${id}`);
                        if (!module.ModelFactory) {
                            throw new Error('No factory!');
                        }
                        const modelFactory = new module.ModelFactory();
                        if (modelFactory.match(context)) {
                            matches.push(context);
                            break;
                        }
                    }
                }
                catch (error) {
                    console.log(error);
                }
            }
            if (matches.length === 0) {
                return null;
            }
            // MXNet
            if (matches.length === 2 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.params')) &&
                matches.some(context => context.identifier.toLowerCase().endsWith('-symbol.json'))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.params'));
            }
            // TensorFlow.js
            if (matches.length > 0 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.bin')) &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.json'))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.json'));
            }
            // ncnn
            if (matches.length > 0 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.bin')) &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.param'))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.param'));
            }
            // ncnn
            if (matches.length > 0 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.bin')) &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.param.bin'))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.param.bin'));
            }
            // NNEF
            if (matches.length > 0 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.nnef')) &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.dat'))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.nnef'));
            }
            // Paddle
            if (matches.length > 0 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.pdmodel')) &&
                (matches.some(context => context.identifier.toLowerCase().endsWith('.pdparams')) ||
                    matches.some(context => context.identifier.toLowerCase().endsWith('.pdopt')) ||
                    matches.some(context => context.identifier.toLowerCase().endsWith('.pdiparams')))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.pdmodel'));
            }
            // Paddle Lite
            if (matches.length > 0 &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === '__model__.nb') &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'param.nb')) {
                matches = matches.filter(context => context.identifier.toLowerCase().split('/').pop() == '__model__.nb');
            }
            // TensorFlow Bundle
            if (matches.length > 1 &&
                matches.some(context => context.identifier.toLowerCase().endsWith('.data-00000-of-00001'))) {
                matches = matches.filter(context => !context.identifier.toLowerCase().endsWith('.data-00000-of-00001'));
            }
            // TensorFlow SavedModel
            if (matches.length === 2 &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'keras_metadata.pb')) {
                matches = matches.filter(context => context.identifier.toLowerCase().split('/').pop() !== 'keras_metadata.pb');
            }
            // Keras
            if (matches.length === 3 &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'model.weights.h5' ||
                    context.identifier.toLowerCase().split('/').pop() === 'model.weights.npz') &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'config.json') &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'metadata.json')) {
                matches = matches.filter(context => context.identifier.toLowerCase().split('/').pop() == 'model.weights.h5' ||
                    context.identifier.toLowerCase().split('/').pop() === 'model.weights.npz');
            }
            if (matches.length === 2 &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'model.weights.h5' ||
                    context.identifier.toLowerCase().split('/').pop() === 'model.weights.npz') &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'config.json')) {
                matches = matches.filter(context => context.identifier.toLowerCase().split('/').pop() == 'model.weights.h5' ||
                    context.identifier.toLowerCase().split('/').pop() === 'model.weights.npz');
            }
            if (matches.length === 2 &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'config.json') &&
                matches.some(context => context.identifier.toLowerCase().split('/').pop() === 'metadata.json')) {
                matches = matches.filter(context => context.identifier.toLowerCase().split('/').pop() == 'config.json');
            }
            // Hailo
            if (matches.length >= 2 && matches.some(context => context.identifier.toLowerCase().endsWith('.metadata.json'))) {
                matches = matches.filter(context => context.identifier.toLowerCase().endsWith('.metadata.json'));
            }
            const match = matches.shift();
            return match;
        });
        const queue = files.slice(0).filter(entry => entry.name.substring(folder.length).indexOf('/') < 0);
        const context = yield filter(queue, entries);
        if (!context) {
            const queue = files.slice(0).filter(entry => entry.name.substring(folder.length).indexOf('/') >= 0);
            return yield filter(queue, entries);
        }
        return context;
    }
    catch (_a) { }
});
exports.default = getEntryContext;
