"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const getModules_1 = __importDefault(require("./getModules"));
const getModel = (context) => __awaiter(void 0, void 0, void 0, function* () {
    const modules = (0, getModules_1.default)(context).filter(module => module && module.length > 0);
    const errors = [];
    let success = false;
    const next = () => __awaiter(void 0, void 0, void 0, function* () {
        if (modules.length > 0) {
            let module = null;
            try {
                const id = modules.shift();
                module = yield require(`../${id}.js`);
            }
            catch (error) {
                success = true;
                modules.splice(0, modules.length);
                errors.push(error);
            }
            if (module) {
                try {
                    const modelFactory = new module.ModelFactory();
                    const target = modelFactory.match(context);
                    if (target) {
                        success = true;
                        const model = yield modelFactory.open(context, target);
                        if (!model.identifier) {
                            model.identifier = context.identifier;
                        }
                        return model;
                    }
                }
                catch (error) {
                    if (context.stream && context.stream.position !== 0) {
                        context.stream.seek(0);
                    }
                    errors.push(error);
                }
            }
            return yield next();
        }
        if (success) {
            if (errors.length === 1) {
                throw errors[0];
            }
        }
        return null;
    });
    return yield next();
});
exports.default = getModel;
