"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const request_1 = __importDefault(require("../utils/request"));
const RootContext_1 = __importDefault(require("../entities/RootContext"));
const FileStream_1 = __importDefault(require("../entities/FileStream"));
const getRootContext = (location) => __awaiter(void 0, void 0, void 0, function* () {
    const basename = path_1.default.basename(location);
    const stat = fs_1.default.statSync(location);
    if (stat.isFile()) {
        const dirname = path_1.default.dirname(location);
        const stream = yield (0, request_1.default)(basename, null, dirname);
        return new RootContext_1.default(dirname, basename, stream);
    }
    else if (stat.isDirectory()) {
        const entries = new Map();
        const walk = dir => {
            for (const item of fs_1.default.readdirSync(dir)) {
                const pathname = path_1.default.join(dir, item);
                const stat = fs_1.default.statSync(pathname);
                if (stat.isDirectory()) {
                    walk(pathname);
                }
                else if (stat.isFile()) {
                    const stream = new FileStream_1.default(pathname, 0, stat.size, stat.mtimeMs);
                    const name = pathname.split(path_1.default.sep).join(path_1.default.posix.sep);
                    entries.set(name, stream);
                }
            }
        };
        walk(location);
        return new RootContext_1.default(location, basename, null, entries);
    }
    throw new Error(`Unsupported path stat '${JSON.stringify(stat)}'.`);
});
exports.default = getRootContext;
