"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const openSignature = (context) => __awaiter(void 0, void 0, void 0, function* () {
    const stream = context.stream;
    if (stream) {
        let empty = true;
        let position = 0;
        while (position < stream.length) {
            const buffer = stream.read(Math.min(4096, stream.length - position));
            position += buffer.length;
            if (!buffer.every(value => value === 0x00)) {
                empty = false;
                break;
            }
        }
        stream.seek(0);
        if (empty) {
            throw new Error('File has no content.');
        }
        /* eslint-disable no-control-regex */
        const entries = [
            { name: 'ELF executable', value: /^\x7FELF/ },
            { name: 'PNG image', value: /^\x89PNG/ },
            {
                name: 'Git LFS header',
                value: /^version https:\/\/git-lfs.github.com/,
            },
            { name: 'Git LFS header', value: /^\s*oid sha256:/ },
            { name: 'GGML data', value: /^lmgg|fmgg|tjgg|algg|fugg/ },
            { name: 'HTML markup', value: /^\s*<html>/ },
            { name: 'HTML markup', value: /^\s*<!doctype\s*html>/ },
            { name: 'HTML markup', value: /^\s*<!DOCTYPE\s*html>/ },
            { name: 'HTML markup', value: /^\s*<!DOCTYPE\s*HTML>/ },
            { name: 'HTML markup', value: /^\s*<!DOCTYPE\s*HTML\s+(PUBLIC|SYSTEM)?/ },
            { name: 'Unity metadata', value: /^fileFormatVersion:/ },
            {
                name: 'Python source code',
                value: /^((#.*(\n|\r\n))|('''.*'''(\n|\r\n))|("""[\s\S]*""")|(\n|\r\n))*(import[ ]+[a-zA-Z_]\w*(\.[a-zA-Z_]\w*)*([ ]+as[ ]+[a-zA-Z]\w*)?[ ]*(,|;|\n|\r\n))/,
            },
            {
                name: 'Python source code',
                value: /^((#.*(\n|\r\n))|('''.*'''(\n|\r\n))|("""[\s\S]*""")|(\n|\r\n))*(from[ ]+([a-zA-Z_]\w*(\.[a-zA-Z_]\w*)*)[ ]+import[ ]+[a-zA-Z]\w*)/,
            },
            {
                name: 'Python virtual environment configuration',
                value: /^home[ ]*=[ ]*/,
                identifier: 'pyvenv.cfg',
            },
            { name: 'Bash script', value: /^#!\/usr\/bin\/env\s/ },
            { name: 'Bash script', value: /^#!\/bin\/bash\s/ },
            { name: 'TSD header', value: /^%TSD-Header-###%/ },
            { name: 'AppleDouble data', value: /^\x00\x05\x16\x07/ },
            {
                name: 'TensorFlow Hub module',
                value: /^\x08\x03$/,
                identifier: 'tfhub_module.pb',
            },
            {
                name: 'V8 snapshot',
                value: /^.\x00\x00\x00.\x00\x00\x00/,
                identifier: 'snapshot_blob.bin',
            },
            {
                name: 'V8 context snapshot',
                value: /^.\x00\x00\x00.\x00\x00\x00/,
                identifier: 'v8_context_snapshot.bin',
            },
            { name: 'V8 natives blob', value: /^./, identifier: 'natives_blob.bin' },
            { name: 'ViSQOL model', value: /^svm_type\s/ },
            { name: 'SenseTime model', value: /^STEF/ },
            { name: 'AES Crypt data', value: /^AES[\x01|\x02]\x00/ },
        ];
        /* eslint-enable no-control-regex */
        const buffer = stream.peek(Math.min(4096, stream.length));
        const content = String.fromCharCode.apply(null, buffer);
        for (const entry of entries) {
            if (content.match(entry.value) && (!entry.identifier || entry.identifier === context.identifier)) {
                throw new Error(`Invalid file content. File contains ${entry.name}.`);
            }
        }
    }
});
exports.default = openSignature;
