"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-nocheck
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const base = __importStar(require("./base"));
const FileStream_1 = __importDefault(require("../entities/FileStream"));
const request = (file, encoding, basename) => {
    return new Promise((resolve, reject) => {
        const dirname = `${process.cwd()}/src/main/services`;
        const pathname = path_1.default.join(basename || dirname, file);
        fs_1.default.stat(pathname, (err, stat) => {
            if (err && err.code === 'ENOENT') {
                reject(new Error(`The file '${file}' does not exist.`));
            }
            else if (err) {
                reject(err);
            }
            else if (!stat.isFile()) {
                reject(new Error(`The path '${file}' is not a file.`));
            }
            else if (stat && stat.size < 0x7ffff000) {
                fs_1.default.readFile(pathname, encoding, (err, data) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve(encoding ? data : new base.BinaryStream(data));
                    }
                });
            }
            else if (encoding) {
                reject(new Error(`The file '${file}' size (${stat.size.toString()}) for encoding '${encoding}' is greater than 2 GB.`));
            }
            else {
                resolve(new FileStream_1.default(pathname, 0, stat.size, stat.mtimeMs));
            }
        });
    });
};
exports.default = request;
