const cache_storage_name = 'dfc-cache-v1';
const start_page = 'index.html';
const offline_page = 'offline.html';
const first_cache_urls = [start_page, offline_page];
const never_cache_urls = [/\/projects/, /\/storage/];

self.addEventListener('install', (e) => {
  console.log('SW installation');
  e.waitUntil(
    caches.open(cache_storage_name).then((cache) => {
      console.log('SW caching first urls');
      return Promise.all(
        first_cache_urls.map((url) => {
          return cache.add(url).catch((res) => {
            console.log(`DFC: ${String(res)} ${url}`);
          });
        }),
      );
    }),
  );
});

self.addEventListener('activate', (e) => {
  console.log('SW activation');
  e.waitUntil(
    caches.keys().then((keys) => {
      return Promise.all(
        keys.map((key) => {
          if (key !== cache_storage_name) {
            console.log('DFC old cache removed', key);
            return caches.delete(key);
          }
        }),
      );
    }),
  );
  return self.clients.claim();
});

self.addEventListener('fetch', (e) => {
  console.log('Fetching:', e.request.url);
  if (!checkFetchRules(e)) return;

  e.respondWith(
    caches.match(e.request).then((response) => {
      if (response) {
        console.log('Serving from cache:', e.request.url);
        return response;
      }

      console.log('Fetching from network:', e.request.url);
      return fetch(e.request)
        .then((networkResponse) => {
          return caches.open(cache_storage_name).then((cache) => {
            if (never_cache_urls.every((regex) => !regex.test(e.request.url))) {
              console.log('Caching new resource:', e.request.url);
              cache.put(e.request, networkResponse.clone());
            }
            return networkResponse;
          });
        })
        .catch(() => {
          console.log('Fetch failed, serving offline page:', e.request.url);
          return caches.match(offline_page);
        });
    }),
  );
});

function checkFetchRules(e) {
  const url = new URL(e.request.url);

  // Check request url from inside domain.
  if (url.origin !== location.origin) return false;

  // Check request url http or https
  if (!/^https?:\/\//i.test(e.request.url)) return false;

  // Show offline page for non-GET requests
  return e.request.method === 'GET';
}
