"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const curryReduceFrontendAndBackendEdgesToEdges = (backendEdges) => (acc, frontendEdge) => {
    const backendEdge = backendEdges === null || backendEdges === void 0 ? void 0 : backendEdges.find(edge => {
        return (frontendEdge === null || frontendEdge === void 0 ? void 0 : frontendEdge.id) === (edge === null || edge === void 0 ? void 0 : edge.id);
    });
    if (backendEdge) {
        acc.push(Object.assign(Object.assign({}, frontendEdge), backendEdge));
    }
    else {
        acc.push(frontendEdge);
    }
    return acc;
};
exports.default = curryReduceFrontendAndBackendEdgesToEdges;
