"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const curryReduceFrontendAndBackendNodesToNodes = (backendNodes) => (acc, frontendNode) => {
    const backendNode = backendNodes === null || backendNodes === void 0 ? void 0 : backendNodes.find((node) => {
        return frontendNode.id === node.id;
    });
    if (backendNode) {
        acc.push(Object.assign(Object.assign(Object.assign({}, frontendNode), backendNode), { data: Object.assign(Object.assign({}, frontendNode.data), backendNode.data) }));
    }
    else {
        acc.push(frontendNode);
    }
    return acc;
};
exports.default = curryReduceFrontendAndBackendNodesToNodes;
