"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getNameFromLayerByOutput_1 = __importDefault(require("../helpers/getNameFromLayerByOutput"));
const getOutputNodeNames_1 = __importDefault(require("../helpers/getOutputNodeNames"));
const curryReduceInputsAndNodesToEdges = (outputs) => (acc, layer) => {
    const source = (0, getNameFromLayerByOutput_1.default)(layer);
    const targets = (0, getOutputNodeNames_1.default)(layer, outputs);
    targets.forEach(target => {
        acc.push({
            id: `${source}-${target}`,
            source,
            target,
            label: '',
        });
    });
    return acc;
};
exports.default = curryReduceInputsAndNodesToEdges;
