"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const toShapeFormat_1 = __importDefault(require("../formatters/toShapeFormat"));
const reduceDimensionsToShape = (dimensionsAcc, dimension) => {
    const dimensionValues = dimension === null || dimension === void 0 ? void 0 : dimension.map(value => {
        if (typeof value === 'object') {
            return value === null || value === void 0 ? void 0 : value.low;
        }
        return value;
    });
    const shape = (0, toShapeFormat_1.default)(dimensionValues);
    dimensionsAcc === null || dimensionsAcc === void 0 ? void 0 : dimensionsAcc.push(shape);
    return dimensionsAcc;
};
exports.default = reduceDimensionsToShape;
