"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const model_storage_1 = __importDefault(require("../multer/model.storage"));
const projects_controller_1 = __importDefault(require("../controllers/projects.controller"));
const router = express_1.default.Router();
const upload = (0, multer_1.default)({ storage: model_storage_1.default });
router.post('/:id', upload.single('file'), projects_controller_1.default.parse);
router.delete('/:id', projects_controller_1.default.delete);
router.post('/:id/upload', upload.single('file'), projects_controller_1.default.upload);
router.post('/:id/hailo', upload.single('file'), projects_controller_1.default.getHailoModel);
router.get('/:id/download/har', projects_controller_1.default.downloadHAR);
exports.default = router;
