"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// @ts-nocheck
const node_child_process_1 = require("node:child_process");
const fs_1 = __importDefault(require("fs"));
const curryMapBackendLayerToOriginalNode_1 = __importDefault(require("../mappers/curryMapBackendLayerToOriginalNode"));
const reduceBackendLayersToOriginalEdges_1 = __importDefault(require("../reducers/reduceBackendLayersToOriginalEdges"));
const getBackendParserModelFormat_1 = __importDefault(require("../helpers/getBackendParserModelFormat"));
const getBackendParserCommand_1 = __importDefault(require("../helpers/getBackendParserCommand"));
const curryMapFrontendInputToOriginalNode_1 = __importDefault(require("../mappers/curryMapFrontendInputToOriginalNode"));
const curryMapFrontendOutputToOriginalNode_1 = __importDefault(require("../mappers/curryMapFrontendOutputToOriginalNode"));
const curryMapFrontendNodeToOriginalNode_1 = __importDefault(require("../mappers/curryMapFrontendNodeToOriginalNode"));
const curryReduceInputsAndNodesToEdges_1 = __importDefault(require("../reducers/curryReduceInputsAndNodesToEdges"));
const getModel_1 = __importDefault(require("../netron/helpers/getModel"));
const getEntryContext_1 = __importDefault(require("../netron/helpers/getEntryContext"));
const getRootContext_1 = __importDefault(require("../netron/helpers/getRootContext"));
const openSignature_1 = __importDefault(require("../netron/helpers/openSignature"));
const curryReduceFrontendAndBackendNodesToNodes_1 = __importDefault(require("../reducers/curryReduceFrontendAndBackendNodesToNodes"));
const curryReduceFrontendAndBackendEdgesToEdges_1 = __importDefault(require("../reducers/curryReduceFrontendAndBackendEdgesToEdges"));
const getFileNameFromPath_1 = __importDefault(require("../utils/getFileNameFromPath"));
const getTempDirLocation_1 = __importDefault(require("../utils/getTempDirLocation"));
const getLogFileLocation_1 = __importDefault(require("../utils/getLogFileLocation"));
const factories_1 = __importDefault(require("../netron/factories/factories"));
const ModelContext_1 = __importDefault(require("../netron/entities/ModelContext"));
const constants_1 = require("../constants");
const removeProjectFiles_1 = __importDefault(require("../helpers/removeProjectFiles"));
let parsingProcess;
const ParsingServices = {
    init: () => {
        factories_1.default.registerFactory('factories/onnx/onnx', [
            '.onnx',
            '.onn',
            '.pb',
            '.onnxtxt',
            '.pbtxt',
            '.prototxt',
            '.txt',
            '.model',
            '.pt',
            '.pth',
            '.pkl',
            '.ort',
            '.ort.onnx',
            'onnxmodel',
            'ngf',
            'json',
        ]);
        factories_1.default.registerFactory('factories/tflite/tflite', [
            '.tflite',
            '.lite',
            '.tfl',
            '.bin',
            '.pb',
            '.tmfile',
            '.h5',
            '.model',
            '.json',
            '.txt',
            '.dat',
            '.nb',
            '.ckpt',
        ]);
    },
    parseWithInternalParser: (_a) => __awaiter(void 0, [_a], void 0, function* ({ path, modelExtension, }) {
        let model;
        const rootContext = yield (0, getRootContext_1.default)(path);
        yield (0, openSignature_1.default)(rootContext);
        const modelContext = new ModelContext_1.default(rootContext);
        model = yield (0, getModel_1.default)(modelContext);
        if (!model) {
            const check = obj => {
                if (obj instanceof Error) {
                    throw obj;
                }
                return obj instanceof Map && obj.size > 0;
            };
            let entries = modelContext.peek('zip');
            if (!check(entries)) {
                entries = modelContext.peek('tar');
                if (!check(entries)) {
                    entries = modelContext.peek('gzip');
                }
            }
            const entryContext = yield (0, getEntryContext_1.default)(entries);
            model = yield (0, getModel_1.default)(entryContext);
        }
        const { _nodes, _inputs, _outputs } = model._graphs[0];
        const mapFrontendInputToOriginalNode = (0, curryMapFrontendInputToOriginalNode_1.default)([..._outputs, ..._nodes]);
        const originalInputs = _inputs.map(mapFrontendInputToOriginalNode);
        const mapFrontendOutputToOriginalNode = (0, curryMapFrontendOutputToOriginalNode_1.default)([..._inputs, ..._nodes]);
        const originalOutputs = _outputs.map(mapFrontendOutputToOriginalNode);
        const mapFrontendNodeToOriginalNode = (0, curryMapFrontendNodeToOriginalNode_1.default)(modelExtension, [..._inputs, ..._nodes], [..._outputs, ..._nodes]);
        const originalNodes = _nodes.map(mapFrontendNodeToOriginalNode);
        const nodes = [...originalInputs, ...originalNodes, ...originalOutputs];
        const reduceInputsAndNodesToEdges = (0, curryReduceInputsAndNodesToEdges_1.default)([..._outputs, ..._nodes]);
        const edges = [..._inputs, ..._nodes].reduce(reduceInputsAndNodesToEdges, []);
        return {
            nodes,
            edges,
        };
    }),
    parseWithExternalParser: ({ path, id, modelExtension, hwArchitecture, startNodeNames = [], endNodeNames = [], }) => {
        return new Promise((resolve, reject) => {
            var _a, _b, _c, _d;
            if (path) {
                const modelFileName = (0, getFileNameFromPath_1.default)(path);
                const format = (0, getBackendParserModelFormat_1.default)(modelExtension);
                const tempDirLocation = (0, getTempDirLocation_1.default)();
                const logFileLocation = (0, getLogFileLocation_1.default)();
                const projectFilesDirectory = `${tempDirLocation}/${id}`;
                const command = (0, getBackendParserCommand_1.default)(format, path, hwArchitecture, modelFileName, startNodeNames, endNodeNames, projectFilesDirectory);
                console.log(command);
                parsingProcess = (0, node_child_process_1.exec)(command);
                let errorMsg = '';
                (_a = parsingProcess === null || parsingProcess === void 0 ? void 0 : parsingProcess.stdout) === null || _a === void 0 ? void 0 : _a.setEncoding('utf8');
                (_b = parsingProcess === null || parsingProcess === void 0 ? void 0 : parsingProcess.stdout) === null || _b === void 0 ? void 0 : _b.on('data', message => {
                    errorMsg = message;
                });
                (_c = parsingProcess === null || parsingProcess === void 0 ? void 0 : parsingProcess.stderr) === null || _c === void 0 ? void 0 : _c.setEncoding('utf8');
                (_d = parsingProcess === null || parsingProcess === void 0 ? void 0 : parsingProcess.stderr) === null || _d === void 0 ? void 0 : _d.on('data', message => {
                    errorMsg = `${errorMsg}\n${message}`;
                });
                parsingProcess.once('exit', status => {
                    if (status) {
                        reject(new Error(`Status code: ${status}\n${errorMsg}`));
                    }
                    else {
                        const JSONFileLocation = `${projectFilesDirectory}/${modelFileName}.json`;
                        fs_1.default.readFile(JSONFileLocation, constants_1.PROJECT_FILE_CONFIG.ENCODING, (err, parsedModelAsString) => {
                            var _a, _b, _c;
                            if (err) {
                                reject(err);
                            }
                            let nodes = [];
                            let edges = [];
                            let detectedPostProcess = false;
                            const parsedModel = JSON.parse(parsedModelAsString) || {};
                            try {
                                detectedPostProcess = !!((_a = parsedModel === null || parsedModel === void 0 ? void 0 : parsedModel.net_params) === null || _a === void 0 ? void 0 : _a.detected_post_process);
                                const mapBackendLayerToOriginalNode = (0, curryMapBackendLayerToOriginalNode_1.default)((_b = parsedModel === null || parsedModel === void 0 ? void 0 : parsedModel.net_params) === null || _b === void 0 ? void 0 : _b.start_node_names, (_c = parsedModel === null || parsedModel === void 0 ? void 0 : parsedModel.net_params) === null || _c === void 0 ? void 0 : _c.end_node_names, parsedModel === null || parsedModel === void 0 ? void 0 : parsedModel.blocks);
                                nodes = Object.entries((parsedModel === null || parsedModel === void 0 ? void 0 : parsedModel.layers) || {}).map(mapBackendLayerToOriginalNode);
                                edges = Object.entries((parsedModel === null || parsedModel === void 0 ? void 0 : parsedModel.layers) || {}).reduce(reduceBackendLayersToOriginalEdges_1.default, []);
                            }
                            catch (error) {
                                nodes = [];
                                edges = [];
                            }
                            fs_1.default.rmSync(JSONFileLocation, { recursive: true, force: true });
                            resolve({
                                nodes,
                                edges,
                                detectedPostProcess,
                            });
                        });
                    }
                    fs_1.default.rmSync(`${logFileLocation}/${constants_1.LOG_FILE_NAME}`, { recursive: true, force: true });
                });
            }
        });
    },
    parseModel: (fileData) => __awaiter(void 0, void 0, void 0, function* () {
        const { id } = fileData;
        let frontendParsingError;
        let internalParserError;
        let frontendNodes = [];
        let frontendEdges = [];
        let backendNodes = [];
        let backendEdges = [];
        let originalModel;
        let detectedPostProcess = false;
        try {
            try {
                ({ nodes: frontendNodes, edges: frontendEdges } = yield ParsingServices.parseWithInternalParser(fileData));
            }
            catch (error) {
                frontendParsingError = new Error(`Can't parse data with frontend parser.`);
            }
            try {
                ({
                    nodes: backendNodes,
                    edges: backendEdges,
                    detectedPostProcess,
                } = yield ParsingServices.parseWithExternalParser(fileData));
            }
            catch (error) {
                internalParserError = error;
            }
            if (frontendParsingError) {
                throw new Error(frontendParsingError.message);
            }
            if (!internalParserError) {
                const reduceFrontendAndBackendNodesToNodes = (0, curryReduceFrontendAndBackendNodesToNodes_1.default)(backendNodes);
                const nodes = frontendNodes.reduce(reduceFrontendAndBackendNodesToNodes, []);
                const reduceFrontendAndBackendEdgesToEdges = (0, curryReduceFrontendAndBackendEdgesToEdges_1.default)(backendEdges);
                const edges = frontendEdges.reduce(reduceFrontendAndBackendEdgesToEdges, []);
                originalModel = {
                    nodes,
                    edges,
                };
            }
            else {
                originalModel = {
                    nodes: frontendNodes,
                    edges: frontendEdges,
                };
            }
            const result = {
                originalModel,
                detectedPostProcess,
                id,
            };
            if (internalParserError) {
                result.error = {
                    type: 'backend',
                    message: internalParserError.message,
                };
                (0, removeProjectFiles_1.default)(id);
            }
            return result;
        }
        catch (error) {
            throw new Error(`Can't parse model.`);
        }
    }),
};
exports.default = ParsingServices;
