import os.path

from hailo_sdk_client.tools.cmd_utils.base_utils import CmdUtilsBaseUtil
from hailo_sdk_client.tools.cmd_utils.cmd_definitions import ClientCommandGroups
from hailo_sdk_client.tools.hrt_profiler.runtime_report_generator import RuntimeReportGenerator
from hailo_sdk_common.logger.logger import default_logger


class RuntimeProfiler(CmdUtilsBaseUtil):
    GROUP = ClientCommandGroups.ANALYSIS_AND_VISUALIZATION
    HELP = "Hailo Runtime Profiler"

    def __init__(self, parser):
        super().__init__(parser)
        parser.add_argument("input_file", type=str, help="hailort.trace file generated using hailortcli")
        parser.add_argument(
            "--output-path",
            type=str,
            default=None,
            help="Output HTML path (default: runtime_report.html)",
        )

        parser.set_defaults(func=self.run)

    def run(self, args):
        output_path = args.output_path if args.output_path else "runtime_report.html"
        with open(args.input_file, "rb") as input_data:
            RuntimeReportGenerator(input_data.read(), output_path).create_report(should_open_web_browser=True)
        default_logger().info(f"Saved Runtime Profiler HTML Report to: {os.path.abspath(output_path)}")
