import base64
import os
import webbrowser

import hailo_sdk_client


class RuntimeReportGenerator:
    PROTOBUF_BASE64_DATA_TOKEN = "%PROTOBUF_BASE64_DATA%"

    def __init__(self, input_data, out_path):
        self._input_data = input_data
        self._out_path = out_path

    def create_report(self, should_open_web_browser=True):
        self._generate_html_report()
        if should_open_web_browser:
            webbrowser.open(self._out_path)

    def _generate_html_report(self):
        with open(self._get_report_template_path(), "rb") as template_fp:
            with open(self._out_path, "wb") as output_fp:
                output_fp.write(self._put_data_in_html(template_fp.read()))

    @staticmethod
    def _get_report_template_path():
        return os.path.join(hailo_sdk_client.tools.__path__[0], "hrt_profiler", "report_template.html")

    def _put_data_in_html(self, html):
        base64_data = base64.b64encode(self._input_data)
        return type(self)._replace_with_data_by_delim(html, base64_data, type(self).PROTOBUF_BASE64_DATA_TOKEN.encode())

    @staticmethod
    def _replace_with_data_by_delim(html_data, new_data, delim):
        txt = list(html_data.partition(delim))
        txt[1] = new_data
        return b"".join(txt)
