import os
import subprocess

import hailo_sdk_client
from hailo_sdk_client.tools.cmd_utils.base_utils import CmdUtilsBaseUtil
from hailo_sdk_client.tools.cmd_utils.cmd_definitions import ClientCommandGroups


class TutorialRunner(CmdUtilsBaseUtil):
    TUTORIALS_DIR = os.path.join(
        os.path.dirname(os.path.dirname(hailo_sdk_client.__file__)),
        "hailo_tutorials/notebooks/",
    )
    GROUP = ClientCommandGroups.OTHER
    HELP = "Runs the tutorials in jupyter notebook"

    def __init__(self, parser):
        super().__init__(parser)
        parser.add_argument(
            "--ip",
            type=str,
            default=None,
            help="Supply an IP to the jupyter-notebook. Use 0.0.0.0 to accept remote connections. Default is None",
        )
        parser.add_argument(
            "--port",
            type=str,
            default=None,
            help="Supply a port to jupyter-notebook. The Default is Automatic",
        )
        parser.set_defaults(func=self.run)

    def run(self, args):
        exec_string = f"jupyter-notebook {self.TUTORIALS_DIR}"
        if args.ip is not None:
            exec_string += f" --ip={args.ip}"

        if args.port is not None:
            exec_string += f" --port={args.port}"

        return subprocess.run(
            exec_string.split(),
            env=os.environ.copy(),
            check=False,
        )
