#!/usr/bin/env python


class SDKException(Exception):
    def __init__(self, message, client_message=None):
        # Note: message will be accessed via the 'args' property, or via
        # the __str__ method. The 'message' property is no longer available in python3
        super().__init__(message)
        if client_message is None:
            client_message = message
        self._client_message = client_message

    @property
    def client_message(self):
        return self._client_message


class SDKCommonException(SDKException):
    pass


class CommonModelException(SDKCommonException):
    pass


class CommonSerializationException(SDKCommonException):
    pass
