#!/usr/bin/env python

import numpy as np


def int_to_sign_magnitude(int_value, bits):
    assert np.abs(int_value) <= (2 ** (bits - 1) - 1)
    if int_value >= 0:
        return int_value

    return int_value * (-1) | (2 ** (bits - 1))


def int_to_2s_complement(int_value, bits):
    if int_value >= 0:
        assert int_value <= (2 ** (bits - 1) - 1)
        return int_value
    else:
        assert np.abs(int_value) <= (2 ** (bits - 1))
        return (2 ** (bits)) + int_value
