import numpy as np

from hailo_sdk_common.hailo_nn.hn_layers.fused_ew_add import FusedEWAddLayer


class FusedEWSubLayer(FusedEWAddLayer):
    _REQUIRES_NATIVE_WEIGHTS = True
    _REQUIRES_QUANTIZED_WEIGHTS = True

    def __init__(self):
        super().__init__()

    @classmethod
    def from_pb(cls, pb, pb_wrapper):
        layer = super().from_pb(pb, pb_wrapper)
        layer._kernel = -1.0 * layer._kernel
        return layer

    @property
    def macs(self):
        # The /2 is because we don't do multiply
        return self.ops / 2

    @property
    def ops(self):
        return float(np.abs(np.prod(np.array(self.output_shape))))

    @classmethod
    def from_layer(cls, old_layer):
        layer = super().from_layer(old_layer)
        layer.kernel = -1.0 * layer.kernel
        return layer
