from hailo_model_optimization.acceleras.utils.acceleras_definitions import LayerHandlerType, LayerSupportStatus
from hailo_sdk_common.hailo_nn.hn_definitions import LayerType, PaddingType
from hailo_sdk_common.hailo_nn.hn_layers.activation_layer import ActivationLayer
from hailo_sdk_common.hailo_nn.layer_equiv_set import EquivClassification


class FusedStandaloneActivationLayer(ActivationLayer):
    def __init__(self):
        super().__init__()
        self._op = LayerType.activation

    def to_pb(self, pb_wrapper, is_multi_scope):
        node = super().to_pb(pb_wrapper, is_multi_scope)
        node.type = pb_wrapper.integrated_hw_graph_base_pb2.PROTO_NETWORK_ACTIVATION
        node.strides.height, node.strides.width, node.strides.features = 1, 1, 1
        node.kernel_shape.height, node.kernel_shape.width, node.kernel_shape.features = 1, 1, 1
        node.dilations.height, node.dilations.width = 1, 1
        node.padding = pb_wrapper.PADDING_TYPE_TO_PB[PaddingType.same]
        return node

    @property
    def requires_quantized_weights(self):
        return True

    def get_equalization_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.activation, is_source=False)

    def get_params_sorter_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def get_dead_channels_removal_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.featurewise, is_source=False)

    def ibc_supported(self):
        return LayerSupportStatus.unsupported
