import numpy as np

from hailo_sdk_common.hailo_nn.hn_definitions import LayerType
from hailo_sdk_common.hailo_nn.hn_layers.fused_standalone_ew_add import FusedStandaloneEWAddLayer


class FusedStandaloneEWSubLayer(FusedStandaloneEWAddLayer):
    def __init__(self):
        super().__init__()
        self._op = LayerType.ew_sub

    @property
    def macs(self):
        # The /2 is because we don't do multiply
        return self.ops / 2

    @property
    def ops(self):
        return float(np.abs(np.prod(np.array(self.output_shape))))

    def to_pb(self, pb_wrapper, is_multi_scope):
        node = super().to_pb(pb_wrapper, is_multi_scope)
        node.type = pb_wrapper.integrated_hw_graph_base_pb2.PROTO_NETWORK_STANDALONE_EW_SUB
        return node

    def get_equalization_handler_type(self, predecessor=None):
        return super().get_equalization_handler_type(predecessor)

    def get_params_sorter_handler_type(self, predecessor=None):
        return super().get_params_sorter_handler_type(predecessor)

    def get_dead_channels_removal_handler_type(self, predecessor=None):
        return super().get_dead_channels_removal_handler_type(predecessor)

    def ibc_supported(self):
        return super().ibc_supported()
