from hailo_sdk_common.hailo_nn.hn_definitions import ActivationType
from hailo_sdk_common.hailo_nn.hn_layers.layer_with_params import LayerWithParams

ACTIVATION_ATTRS = [
    "leaky_alpha",
    "swish_beta",
    "activation_threshold",
    "activation_greater_values",
    "activation_delta_bias",
    "activation_less_values",
    "hardsigmoid_alpha",
    "hardsigmoid_beta",
    "clip_min",
    "clip_max",
    "prelu_slope",
    "pow_exponent",
]


class LayerWithActivation(LayerWithParams):
    """
    LayerWithActivation is a base class for layers which have custom parameters and an activation
    in their HN representation.
    """

    def __init__(self):
        super().__init__()
        self._activation = ActivationType.linear
        self._is_activation_fusible = True

    def move_params(self, old_layer):
        super().move_params(old_layer)
        for attr in ACTIVATION_ATTRS:
            attr_value = getattr(old_layer, attr) if hasattr(old_layer, attr) else None
            if attr_value is not None:
                setattr(self, attr, attr_value)

    @property
    def is_activation_fusible(self):
        return self._is_activation_fusible

    @is_activation_fusible.setter
    def is_activation_fusible(self, is_activation_fusible):
        self._is_activation_fusible = is_activation_fusible

    @property
    def activation(self):
        return self._activation

    @activation.setter
    def activation(self, activation):
        self._activation = activation

    @property
    def leaky_alpha(self):
        return self._leaky_alpha

    @leaky_alpha.setter
    def leaky_alpha(self, leaky_alpha):
        self._leaky_alpha = leaky_alpha

    @property
    def swish_beta(self):
        return self._swish_beta

    @swish_beta.setter
    def swish_beta(self, swish_beta):
        self._swish_beta = swish_beta

    @property
    def activation_threshold(self):
        return self._activation_threshold

    @activation_threshold.setter
    def activation_threshold(self, activation_threshold):
        self._activation_threshold = activation_threshold

    @property
    def activation_delta_bias(self):
        return self._activation_delta_bias

    @activation_delta_bias.setter
    def activation_delta_bias(self, activation_delta_bias):
        self._activation_delta_bias = activation_delta_bias

    @property
    def activation_greater_values(self):
        return self._activation_greater_values

    @activation_greater_values.setter
    def activation_greater_values(self, activation_greater_values):
        self._activation_greater_values = activation_greater_values

    @property
    def activation_less_values(self):
        return self._activation_less_values

    @activation_less_values.setter
    def activation_less_values(self, activation_less_values):
        self._activation_less_values = activation_less_values

    @property
    def hardsigmoid_alpha(self):
        return self._hardsigmoid_alpha

    @hardsigmoid_alpha.setter
    def hardsigmoid_alpha(self, hardsigmoid_alpha):
        self._hardsigmoid_alpha = hardsigmoid_alpha

    @property
    def hardsigmoid_beta(self):
        return self._hardsigmoid_beta

    @hardsigmoid_beta.setter
    def hardsigmoid_beta(self, hardsigmoid_beta):
        self._hardsigmoid_beta = hardsigmoid_beta

    @property
    def clip_min(self):
        return self._clip_min

    @clip_min.setter
    def clip_min(self, clip_min):
        self._clip_min = clip_min

    @property
    def clip_max(self):
        return self._clip_max

    @clip_max.setter
    def clip_max(self, clip_max):
        self._clip_max = clip_max

    @property
    def prelu_slope(self):
        return self._prelu_slope

    @prelu_slope.setter
    def prelu_slope(self, prelu_slope):
        self._prelu_slope = prelu_slope

    @property
    def pow_exponent(self):
        return self._pow_exponent

    @pow_exponent.setter
    def pow_exponent(self, pow_exponent):
        self._pow_exponent = pow_exponent
