from hailo_model_optimization.acceleras.utils.acceleras_definitions import LayerHandlerType, LayerSupportStatus
from hailo_sdk_common.hailo_nn.hn_definitions import LayerType
from hailo_sdk_common.hailo_nn.hn_layers.layer import Layer
from hailo_sdk_common.hailo_nn.layer_equiv_set import EquivClassification


class OneHotLayer(Layer):
    def __init__(self):
        super().__init__()
        self._op = LayerType.one_hot
        self._num_classes = None

    @classmethod
    def create(cls, original_name, input_vertex_order, num_classes, output_shapes=None):
        layer = super().create(original_name, input_vertex_order, output_shapes)
        layer.num_classes = num_classes
        return layer

    def _calc_output_shape(self):
        return [*self.input_shape[:-1], self.num_classes]

    @property
    def num_classes(self):
        return self._num_classes

    @num_classes.setter
    def num_classes(self, num_classes):
        self._num_classes = num_classes

    def get_equalization_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.transparent, is_source=False)

    def get_params_sorter_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def get_dead_channels_removal_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def ibc_supported(self):
        return LayerSupportStatus.unsupported
