import numpy as np

from hailo_model_optimization.acceleras.utils.acceleras_definitions import LayerHandlerType, LayerSupportStatus
from hailo_sdk_common.hailo_nn.hn_definitions import LayerType
from hailo_sdk_common.hailo_nn.hn_layers.reduce_sum import ReduceSumLayer
from hailo_sdk_common.hailo_nn.layer_equiv_set import EquivClassification


class ReduceMeanLayer(ReduceSumLayer):
    def __init__(self):
        super().__init__()
        self._op = LayerType.reduce_mean

    def to_pb(self, pb_wrapper, is_multi_scope):
        node = super().to_pb(pb_wrapper, is_multi_scope)
        node.type = pb_wrapper.integrated_hw_graph_base_pb2.PROTO_NETWORK_REDUCE_MEAN
        return node

    @property
    def ops(self):
        # A little trick that simplifies it all
        total_input_size = float(np.abs(np.prod(np.array(self.input_shape))))
        total_output_size = float(np.abs(np.prod(np.array(self.output_shape))))
        # Each input is being summed one time, add to that the number of divs (one div per output pixel)
        return total_input_size + total_output_size

    def get_equalization_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def get_params_sorter_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def get_dead_channels_removal_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def ibc_supported(self):
        return LayerSupportStatus.unsupported
