from hailo_model_optimization.acceleras.utils.acceleras_definitions import LayerHandlerType, LayerSupportStatus
from hailo_sdk_common.hailo_nn.hn_definitions import LayerType
from hailo_sdk_common.hailo_nn.hn_layers.layer import Layer
from hailo_sdk_common.hailo_nn.layer_equiv_set import EquivClassification


class ScatterNDLayer(Layer):
    def __init__(self):
        super().__init__()
        self._op = LayerType.scatter_nd
        self._indices = None
        self._number_of_inputs_supported = 2

    @classmethod
    def create(cls, original_name, input_vertex_order, indices, output_shapes=None):
        layer = super().create(original_name, input_vertex_order, output_shapes)
        layer.indices = indices
        return layer

    @property
    def indices(self):
        return self._indices

    @indices.setter
    def indices(self, value):
        self._indices = value

    def _calc_output_shape(self):
        return self.output_shapes[0]

    def get_equalization_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.transparent, is_source=False)

    def get_params_sorter_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def get_dead_channels_removal_handler_type(self, predecessor=None):
        return EquivClassification(LayerHandlerType.unsupported, is_source=False)

    def ibc_supported(self):
        return LayerSupportStatus.unsupported
