#!/usr/bin/env python

from hailo_sdk_common.hailo_nn.hailo_nn import HailoNN


def load_nn(hn_path):
    """
    loads HN to get Hailo NN base description for further processing.
    """
    with open(hn_path, "rb") as hn_file:
        hailo_nn = HailoNN.from_hn(hn_file.read())
    hailo_nn.fill_default_quantization_params()
    return hailo_nn
