#!/usr/bin/env python

import numpy as np


def calc_normalization_params(mean, std, kernel_shape):
    std = np.array(std, dtype=np.float128)
    # Add a small number to avoid dividing by 0
    std[std == 0] += 1e-7

    kernel = np.ones(kernel_shape, dtype=np.float128)
    kernel /= std.reshape(kernel_shape)
    bias = -np.array(mean, dtype=np.float128) / std

    return kernel.astype(np.float32), bias.astype(np.float32)
