#!/usr/bin/env python

import tensorflow as tf
from future.utils import with_metaclass

from hailo_sdk_common.paths_manager.paths import SDKPaths, Singleton


class HSimWrapper(with_metaclass(Singleton, object)):
    def __init__(self):
        self._hsim = None

    def load(self):
        if self._hsim is None:
            self._load()

    def _load(self):
        hsim_path = SDKPaths().join_sdk_client("emulator/emulator/lib/HSim.so")
        self._hsim = tf.load_op_library(hsim_path)

    @property
    def hsim(self):
        return self._hsim
