#!/usr/bin/env python
import os
from configparser import ConfigParser

from hailo_sdk_common.paths_manager.paths import SDKPaths

CONFIG_FILE_ENV_VAR = "HAILO_SDK_CONFIG_PATH"


def get_home_hailo_dir():
    return os.path.expanduser("~/.hailo")


def get_parsed_config_from_path(config_path=None):
    actual_config_path = _get_config_path_with_default(config_path)
    config = ConfigParser()
    if actual_config_path:
        with open(actual_config_path) as config_file:
            config.read_file(config_file)
    return config


def _get_config_path_with_default(config_path=None):
    if config_path is not None and os.path.isfile(config_path):
        return config_path

    environ_config_path = os.environ.get(CONFIG_FILE_ENV_VAR)
    if environ_config_path:
        return environ_config_path

    default_path = _get_config_path()
    if os.path.isfile(default_path):
        return default_path


def _get_config_path():
    config_file_name = "config"

    if not SDKPaths().is_release:
        full_path = os.path.join(SDKPaths().join_sdk("../"), config_file_name)
        if os.path.exists(full_path):
            return full_path
        # This is a CI nightly workaround because we are in unpack mode but installing whl's
        # In this case SDKPaths() is inside the site packages and not the sdk root. the workaround is to look for
        # local dir
        elif os.path.exists(config_file_name):
            return config_file_name

    elif os.path.exists(config_file_name):
        return config_file_name

    return os.path.join(get_home_hailo_dir(), config_file_name)
