#!/usr/bin/env python
# This file is duplicated from platform so the build of common won't rely on installing platform
def get_version(package_name):
    # See: https://packaging.python.org/guides/single-sourcing-package-version/ (Option 5)
    # We assume that the installed package is actually the same one we import. This assumption may
    # break in some edge cases e.g. if the user modifies sys.path manually.
    try:
        from importlib.metadata import version

        if package_name in (
            "hailo_sdk_client",
            "hailo_sdk_common",
        ):
            # hailo_sdk_client and hailo_sdk_common used to have their own setup.py and therefore had their own versions.
            # Since v3.14 they were combined into "hailo-dataflow-compiler" package, therefore, only "hailo-dataflow-compiler"
            # will have a version accessible via importlib.metadata.
            return version("hailo_dataflow_compiler")

        return version(package_name)
    except Exception:
        return "unknown"
