#!/usr/bin/env python

from builtins import zip

import tensorflow as tf
from tensorflow.python.framework.errors_impl import FailedPreconditionError

from hailo_sdk_common.logger.logger import default_logger

logger = default_logger()


def get_variables_values(session, remove_zero=False):
    variables = tf.compat.v1.get_collection(tf.compat.v1.GraphKeys.GLOBAL_VARIABLES)
    if variables is None or len(variables) == 0:
        ops = session.graph.get_operations()
        variables = [session.graph.get_tensor_by_name(f"{op.name}:0") for op in ops if "Variable" in op.type]
    try:
        session_result = session.run(variables)
    except FailedPreconditionError:
        logger.warning(
            "Fetching variable values one-by-one due to ckpt restoring error - This might take a few minutes.",
        )
        session_result = []
        for var in variables:
            try:
                session_result.append(session.run(var))
            except FailedPreconditionError:
                pass

    values = {}
    for variable, value in zip(variables, session_result):
        if remove_zero:
            values[variable.name[:-2]] = value
        else:
            values[variable.name] = value

    return values
