from functools import wraps


class InvalidStateException(Exception):
    """Raised when trying to execute api in state that is not allowed."""


def allowed_states(*states):
    def wrap(func):
        @wraps(func)
        def wrapped_func(self, *args, **kwargs):
            if self._state not in states:
                raise InvalidStateException(
                    f"The execution of {func.__name__} is not available under the state: {self._state.value}",
                )
            return func(self, *args, **kwargs)

        return wrapped_func

    return wrap
