import numpy as np
from numba import njit


@njit
def bbox_overlaps(boxes, query_boxes):
    boxes_count = boxes.shape[0]
    secondary_boxes_count = query_boxes.shape[0]
    overlaps = np.zeros((boxes_count, secondary_boxes_count), dtype=float)
    for k in range(secondary_boxes_count):
        box_area = (query_boxes[k, 2] - query_boxes[k, 0] + 1) * (query_boxes[k, 3] - query_boxes[k, 1] + 1)
        for n in range(boxes_count):
            iw = min(boxes[n, 2], query_boxes[k, 2]) - max(boxes[n, 0], query_boxes[k, 0]) + 1
            if iw > 0:
                ih = min(boxes[n, 3], query_boxes[k, 3]) - max(boxes[n, 1], query_boxes[k, 1]) + 1
                if ih > 0:
                    ua = float((boxes[n, 2] - boxes[n, 0] + 1) * (boxes[n, 3] - boxes[n, 1] + 1) + box_area - iw * ih)
                    overlaps[n, k] = iw * ih / ua
    return overlaps
